unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    DateTimePicker1: TDateTimePicker;
    DateTimePicker2: TDateTimePicker;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Button3: TButton;
    function SetFileDateTime(FileName : String; NewDateTime : TDateTime): Boolean;
    procedure Button1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var i: word;
begin
    DateTimePicker1.Time:=DateTimePicker2.Time;
    if OpenDialog1.Execute then begin
        for i:=0 to OpenDialog1.Files.Count-1 do begin
            //ShowMessage(OpenDialog1.Files[i]);
            if not SetFileDateTime(OpenDialog1.Files[i],DateTimePicker1.DateTime) then ShowMessage('Failed with '+OpenDialog1.Files[i]);
        end;
        ShowMessage('Done!');
    end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
    DateTimePicker1.Date:=now;
    DateTimePicker2.Time:=now;
end;

//http://www.swissdelphicenter.ch/en/showcode.php3?id=224
function TForm1.SetFileDateTime(FileName : String; NewDateTime : TDateTime): Boolean;
var
  FileHandle: Integer;
  FileTime: TFileTime;
  LFT: TFileTime;
  LST: TSystemTime;
begin
  FileHandle:=0;
  Result := False;
  Try
    DecodeDate(NewDateTime, LST.wYear, LST.wMonth, LST.wDay);
    DecodeTime(NewDateTime, LST.wHour, LST.wMinute, LST.wSecond,LST.wMilliSeconds);
    IF SystemTimeToFileTime(LST, LFT) Then
    begin
      IF LocalFileTimeToFileTime(LFT, FileTime) Then
      begin
        FileHandle := FileOpen(FileName, fmOpenReadWrite or
                               fmShareExclusive);
        IF SetFileTime(FileHandle, NIL, NIL, @FileTime) Then
          Result := True;
        end;
      end;
   Finally
     FileClose(FileHandle);
   end;
end;

procedure TForm1.FormActivate(Sender: TObject);
begin
    DateTimePicker1.Date:=now;
    DateTimePicker2.Time:=now;
end;

end.
